//Experiment No.11
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Dr. T. Subbulaskhmi, Professor, School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for Network Topology Creation and display using various methods

//1.Topology creation and colouring using grid method 2. Topology creation and colouring using random method 3. Topology Creation using detailed method


//1.Topology creation and colouring using grid method 
clear;
clf;

NumberOfRows=10;// number of rows
NumberOfColumns=10;//number of columns
XCoordinatesOfArea=1000;//Area of network x coordinates
YCoordinatesOfArea=1000;//Area of network y coordinates
radius = 100;
colour = 2;
[TopologyGraph]=NL_T_Grid(NumberOfRows,NumberOfColumns,XCoordinatesOfArea,YCoordinatesOfArea);// generation of a topology in respect with the grid method
WindowIndex=1;//window index
NameOfNetwork = "Network Created with Grid and Showgraph method";
InitialSquareArea=NL_M_Background(WindowIndex,NameOfNetwork);//initial square area

xlabel("x coordinates of node", "fontsize", 2)
ylabel("Y coordinates of node");

InitialSquareArea=NL_M_GraphDisplayUpdate(TopologyGraph,WindowIndex,radius,colour);

//2. Topology creation and colouring using random method
NetworkSize=5;//network size
NetworkAreaSide=1000;//network squared area side
LocalityRadius=1000;//Locality radius
[TopologyGraph]=NL_T_LocalityConnex(NetworkSize,NetworkAreaSide,LocalityRadius);//generation of a topology
WindowIndex=2;//window index
InitialSquareArea=NL_G_ShowGraphN(TopologyGraph,WindowIndex);//graph visualization
xtitle("Channel Creation","X-Node","Y-Node");
[go,n,e]=NL_G_WCDS(TopologyGraph)
ListOfChannels=[2];//list of chanels
[goc]=NL_G_WCDSChannel(go,NetworkSize,e,ListOfChannels);//application of NL_G_WCDSChannel
WindowIndex=3;//window index
InitialSquareArea=NL_G_ShowGraph(goc,WindowIndex);//graph visualization
xtitle("Channel Creation","X-Node","Y-Node");
disp(go,NetworkSize,e,ListOfChannels);


//3. Topology Creation using detailed method
NameOfNetwork='Detailed topology';// Name of your network
NetworkSize=8;//Number of Nodes in the network
StartingNodes=[1 2 3 4 1 2 3 4 6 7 8 6 7 8]; //Starting Nodes of the connection lines
EndingNodes=[2 3 4 5 3 6 7 8 2 4 5 1 2 3]; //Ending Node of the connection 
XCoordinatesOfNode=[100 200 500 300 400 600 700 400]; // X-Coordinates of the nodes
YCoordinatesOfNode=[300 400 500 600 700 800 900 950]; // Y-Coordinates of the nodes
[g1]=NL_G_MakeGraph(NameOfNetwork,NetworkSize,StartingNodes,EndingNodes,XCoordinatesOfNode,YCoordinatesOfNode)//Creates the Bus topoplogy
WindowIndex=4; //Graph Window Number
[f1] = NL_G_ShowGraph(g1,WindowIndex);// Visualize the Graph along with indices for Nodes and Edges
xtitle("Bus Topology Creation","X-Node","Y-Node");
NumberOfLines=5;//number of lines
NumberOfColumns=5;//number of columns
XCoordinatesOfArea=1000;//network area x-side
YCoordinatesOfArea=1000;//network area x-side
[TopologyGraph]=NL_T_Grid(NumberOfLines,NumberOfColumns,XCoordinatesOfArea,YCoordinatesOfArea);//generation of a topology in respect with the grid method
WIndowIndex=5;//window index
[f]=NL_G_ShowGraph(TopologyGraph,WIndowIndex);//application of NL_G_ShowGraph
xtitle("Nodes mentioned in node vector area squae 1000","X-Node","Y-Node");
NumberOfLines=5;//number of lines
NumberOfColumns=7;//number of columns
XCoordinatesOfArea=500;//network area x-side
YCoordinatesOfArea=500;//network area x-side
[TopologyGraph]=NL_T_Grid(NumberOfLines,NumberOfColumns,XCoordinatesOfArea,YCoordinatesOfArea);//generation of a topology in respect with the grid method
WindowIndex=6;//window index
[f]=NL_G_ShowGraph(TopologyGraph,WindowIndex);//application of NL_G_ShowGraph
xtitle("Nodes mentioned in node vector","X-Node","Y-Node");

NumberOfLines=5;//number of lines
NumberOfColumns=5;//number of columns
XCoordinatesOfArea=500;//network area x-side
YCoordinatesOfArea=500;//network area x-side
[TopologyGraph]=NL_T_Grid(NumberOfLines,NumberOfColumns,XCoordinatesOfArea,YCoordinatesOfArea);//generation of a topology in respect with the grid method
WindowIndex=7;//window index
[f]=NL_G_ShowGraph(TopologyGraph,WindowIndex);//application of NL_G_ShowGraph
xtitle("Topology Generation Grid Method","X-Node","Y-Node");
//4. Display the number of nodes and edges 
[ExtractNode,ExtractEdge]=NL_G_GraphSize(TopologyGraph);//Extract the number of nodes and edges
disp('Number of nodes:',ExtractNode); //display the number of nodes and edges 
disp('Number of edges:',ExtractEdge);

//2. Colour the nodes and Edges
NodeColor=30; // Node Colour 2:[Blue],3:[Green], 5:[Red]
BorderThickness=10; // Node Border thickness
NodeDiameter=25; //Node diameter 
WindowIndex=8;//window index
nodes=[1 2 4 6 8 10 12 14];//list of nodes
[GraphHighlight,NodeVector]=NL_G_HighlightNodes(TopologyGraph,nodes,NodeColor,BorderThickness,NodeDiameter,WindowIndex);//Highlight the specific nodes mentioned in the 'nodes' vector
xtitle("Nodes mentioned in node vector","X-Node","Y-Node");
EdgeColor=5;// Edge Colour
EdgeWidth=5;//Edge Width
WIndowIndex=9;//window index
edges=[1 5 7];//list of edges
[GraphHighlight,NodeVector]=NL_G_HighlightEdges(GraphHighlight,edges,EdgeColor,EdgeWidth,WIndowIndex);//Highlight the specific nodes mentioned in the 'edges' vector
xtitle("Nodes mentioned in edge vector","X-Node","Y-Node");
